uniform sampler2D s1;
uniform int colorR;
uniform int colorG;
uniform int colorB;
uniform float opacity;
int Overlay(int base, int top)
{
    if (base < 128) 
    {
        return (2 * base * top) / 255;
    }
    else 
    {
        return 255 - 2 * (255 - base) * (255 - top) / 255;
    }
}
void main()
{
    vec4 pixel = texture2D(s1, gl_TexCoord[0].xy);

    int pixelR = int(pixel.r * 255.0);
    int pixelG = int(pixel.g * 255.0);
    int pixelB = int(pixel.b * 255.0);
    int pixelA = int(pixel.a * 255.0);

    int blendingR = colorR;
    int blendingG = colorG;
    int blendingB = colorB;

    int resultR = pixelR;
    int resultG = pixelG;
    int resultB = pixelB;
    int resultA = pixelA;

    if (colorR >= 0 && colorG >= 0 && colorB >= 0)
    {
        resultR = Overlay(pixelR, blendingR);
        resultG = Overlay(pixelG, blendingG);
        resultB = Overlay(pixelB, blendingB);
    }

     vec4 col = vec4(resultR / 255.0, resultG / 255.0, resultB / 255.0, pixel.a);

    if (opacity >= 0.0) 
    {
        col.a = min(col.a, opacity);
    }

    gl_FragColor = col;
}