// sharpen.glsl
uniform sampler2D texture;
uniform vec2 texelSize; // wielkość tekstury
uniform float sharpness; // poziom wyostrzenia (np. 1.0, 1.5, 2.0)

void main()
{
    vec2 uv = gl_TexCoord[0].xy;
    
    // Pobieramy kolory sąsiadujących pikseli
    vec4 color = texture2D(texture, uv);
    vec4 north = texture2D(texture, uv + vec2(0.0, texelSize.y));
    vec4 south = texture2D(texture, uv - vec2(0.0, texelSize.y));
    vec4 east = texture2D(texture, uv + vec2(texelSize.x, 0.0));
    vec4 west = texture2D(texture, uv - vec2(texelSize.x, 0.0));
    
    // Zastosowanie jądra wyostrzającego z dynamicznym poziomem wyostrzenia
    vec4 sharpenedColor = color * (1.0 + 4.0 * sharpness) - (north + south + east + west) * sharpness;

    // Wyjście końcowe
    gl_FragColor = vec4(sharpenedColor.rgb, color.a);
}
